VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "SettingClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private IniFile$

Private Declare Function GetPrivateProfileInt Lib "kernel32" Alias "GetPrivateProfileIntA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal nDefault As Long, ByVal lpFileName As String) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function GetProfileInt Lib "kernel32" Alias "GetProfileIntA" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal nDefault As Long) As Long
Private Declare Function GetProfileString Lib "kernel32" Alias "GetProfileStringA" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
Private Declare Function WriteProfileString Lib "kernel32" Alias "WriteProfileStringA" (ByVal lpszSection As String, ByVal lpszKeyName As String, ByVal lpszString As String) As Long

Private Type POINTAPI
        X As Long
        Y As Long
End Type

Private Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Private Type WINDOWPLACEMENT
        Length As Long
        Flags As Long
        showCmd As Long
        ptMinPosition As POINTAPI
        ptMaxPosition As POINTAPI
        rcNormalPosition As RECT
End Type

Private Declare Function GetWindowPlacement Lib "user32" (ByVal hwnd As Long, lpWndPl As WINDOWPLACEMENT) As Long
Private Declare Function SetWindowPlacement Lib "user32" (ByVal hwnd As Long, lpWndPl As WINDOWPLACEMENT) As Long
Public Sub Init(f$)
    IniFile = f
End Sub
Public Function GetStr$(header$, key$, def$)
    Dim X As String * 512, a&
    a = GetPrivateProfileString(header, key, "", X, 512, IniFile)
    If a = 0 Then
        GetStr = def
    Else
        GetStr = Left$(X, a)
    End If
End Function
Public Function GetStrSpc$(header$, key$, def$)
    Dim X As String * 512, a&
    a = GetPrivateProfileString(header, key, "", X, 512, IniFile)
    If a = 0 Then
        GetStrSpc = def
    Else
        GetStrSpc = UToSpace(Left$(X, a))
    End If
End Function
Public Sub PutStr(header$, key$, Text$)
    Dim Text2$
    Text2 = Text
    SpaceToU (Text2)
    WritePrivateProfileString header, ByVal key$, ByVal Text2$, IniFile
End Sub
Public Sub PutInt(header$, key$, i%)
    PutStr header, key, CStr(i)
End Sub
Public Sub WindowPostionSave(f As Form)
    Dim w As WINDOWPLACEMENT, X$
    w.Length = LenB(w)
    GetWindowPlacement f.hwnd, w
    X = CStr(f.WindowState) + "," + CStr(w.rcNormalPosition.Left) + "," + CStr(w.rcNormalPosition.Top) + "," + CStr(w.rcNormalPosition.Right) + "," + CStr(w.rcNormalPosition.Bottom)
    PutStr "WindowLocation", f.Name, X
End Sub
Private Function Getitem$(ByRef X$, delim$)
    Dim i%
    i = InStr(X$, delim$)
    If i Then
        Getitem = Left$(X, i - 1)
        X = Mid$(X, i + Len(delim))
    Else
        Getitem = X
        X = ""
    End If
End Function
Public Sub WindowPostionRestore(f As Form)
    Dim w As WINDOWPLACEMENT, X$, s%
    
    X = GetStr("WindowLocation", f.Name, "")
    If X = "" Then
        f.Move (Screen.Width - f.Width) / 2, (Screen.Height - f.Height) / 2
        Exit Sub
    End If
    
    s = Val(Getitem(X, ","))
    w.Length = LenB(w)
    w.rcNormalPosition.Left = Val(Getitem(X, ","))
    w.rcNormalPosition.Top = Val(Getitem(X, ","))
    w.rcNormalPosition.Right = Val(Getitem(X, ","))
    w.rcNormalPosition.Bottom = Val(Getitem(X, ","))
    
    SetWindowPlacement f.hwnd, w
    
    If (f.Left + f.Width) > Screen.Width Then f.Left = Screen.Width - f.Width
    If (f.Top + f.Height) > Screen.Height Then f.Top = Screen.Height - f.Height
    If f.Left < 0 Then f.Left = 0
    If f.Top < 0 Then f.Top = 0
    
    f.WindowState = s
End Sub
Public Function GetInt%(header$, key$, def%)
    Dim X$, i%
    X = GetStr(header, key, "")
    If X = "" Then
        GetInt = def
    Else
        GetInt = Val(X)
    End If
End Function

Public Function GetLong(header$, key$, def As Long) As Long
    Dim X$, i As Long
    X = GetStr(header, key, "")
    If X = "" Then
        GetLong = def
    Else
        GetLong = Val(X)
    End If
End Function

Public Sub OptionsSave(header$, key$, c As Variant)
    Dim i%, o As OptionButton
    For Each o In c
        If o.Value Then PutInt header, key, o.Index: Exit For
    Next
End Sub
Public Sub OptionsRestore(header$, key$, c As Variant, def%)
    c(GetInt(header, key, def)) = True
End Sub
Public Sub CheckSave(header$, key$, c As CheckBox)
    PutInt header, key, c.Value
End Sub
Public Sub CheckRestore(header$, key$, c As CheckBox, def%)
    c.Value = GetInt(header, key, def)
End Sub
Public Function ComboRestoreFromKeys(header$, c As ComboBox, FirstEntry$, LastSelectedEntry$, DefIndex%)
    Dim X$, a&, i%, j%
    
    j = -1
    
    c.Clear
    If Len(FirstEntry) Then
        c.AddItem FirstEntry
        If FirstEntry = LastSelectedEntry Then j = 0
    End If
    X$ = Space$(1024)
    a = GetPrivateProfileString(header, ByVal 0&, "", X, 1024, IniFile)
    
'ByVal lpApplicationName&, lpKeyName As Any, lpDefault$, ByVal String$, ByVal nSize&, ByVal lpFileName&
    
    If a Then
        X = Left$(X, InStr(X, Chr$(0) + Chr$(0)))
        While Len(X) > 1
            i = InStr(X, Chr$(0))
            c.AddItem Left$(X, i - 1)
            If j <> -1 And Left$(X, i - 1) = LastSelectedEntry Then j = 0
            X$ = Mid$(X$, i + 1)
        Wend
    End If
    If j = -1 Then j = DefIndex
    c.ListIndex = j
End Function
Private Function UToSpace(ByVal X$)
    Dim i%
    i = InStr(X, "_")
    While i
        Mid$(X, i, 1) = " "
        i = InStr(X, "_")
    Wend
    UToSpace = X
End Function
Private Function SpaceToU(ByVal X$)
    Dim i%
    i = InStr(X, " ")
    While (i)
        Mid$(X, i, 1) = "_"
        i = InStr(X, " ")
    Wend
    SpaceToU = X
End Function
Private Sub Class_Initialize()
        IniFile = App.Path + "\" + App.EXEName + ".ini"
End Sub
Public Sub ClearKey(ByVal hdr$, ByVal key$)
    WritePrivateProfileString hdr$, ByVal key$, ByVal 0&, IniFile$
End Sub

Public Sub DeleteAllKeys(File$, hdr$)
    WritePrivateProfileString hdr$, ByVal 0&, ByVal 0&, IniFile$
End Sub

Public Sub DeleteHeader(ByVal File$, ByVal hdr$)
    WritePrivateProfileString hdr$, ByVal 0&, "", IniFile$
End Sub

Public Sub DeleteKey(ByVal hdr$, ByVal key$)
    WritePrivateProfileString hdr$, ByVal key$, ByVal 0&, IniFile$
End Sub

